unit uROR_CCRCmdLine;

interface

uses
  uROR_CmdLineParams;

type

  TCCRCommandLineParameters = class(TCCRCmdLineParams)
  private

    fRegistryName: String;

  protected

    procedure QueryHelpItems(HelpItems: TCCRCmdLineHelpItems); override;

  public

    procedure Parse; override;

    property RegistryName: String  read fRegistryName;

  end;

implementation

uses
  uROR_Utilities;

procedure TCCRCommandLineParameters.Parse;
var
  i: Integer;
begin
  inherited;
  for i := 1 to ParamCount do
    begin
      if StartString(ParamStr(i),
        ['/r=', '-r=', 'r=', '/registry=', '-registry='], False) then
        fRegistryName := Piece(ParamStr(i), '=', 2);
    end;
end;

procedure TCCRCommandLineParameters.QueryHelpItems(
  HelpItems: TCCRCmdLineHelpItems);
begin
  inherited;
  HelpItems.Add(
    '/registry=, /r=, R=,'#13'-registry=, -r=', 'Registry name.');
end;

end.
